![](https://user-images.githubusercontent.com/5574267/130804494-a9d2d69c-f170-4576-b2e1-0bb7f13dd92d.gif)

# Requirements

vue version >=3.2.0

# Installation

```bash
npm install --save vue3-toastify
# yarn add vue3-toastify
```

# Demo

[A demo is worth a thousand words](https://vue3-toastify.js-bridge.com)

[备用地址](https://vue3-toastify.netlify.app)

# Document

Check the [documentation](https://vue3-toastify.js-bridge.com/get-started/introduction.html) to get you started!

[备用地址](https://vue3-toastify.netlify.app/get-started/introduction.html)

# The gist

```html
<template>
  <div>
    <button @click="notify">Notify !</button>
  </div>
</template>

<script>
import { toast } from 'vue3-toastify';
import 'vue3-toastify/dist/index.css';

export default {
   name: "App",
   setup() {
    const notify = () => {
      toast("Wow so easy !", {
        autoClose: 1000,
      }); // ToastOptions
    }
    return { notify };
   }
};
</script>
```

## Init/Update Global Props

```ts
// main.ts
import Vue3Toastify, { type ToastContainerOptions } from 'vue3-toastify';

app.use(Vue3Toastify, {
  autoClose: 3000,
} as ToastContainerOptions);
```

```js
// tsconfig.json
{
  "compilerOptions": {
    "types": [
      "vue3-toastify/global"
    ]
  }
}
```

or

```ts
updateGlobalOptions({ rtl: true });

toast.success('Wow so easy!');
```

## nuxt

[A nuxt demo](https://stackblitz.com/edit/nuxt-starter-1gszqs?file=app.vue,plugins%2Fvue3-toastify.ts)

- plugins/vue3-toastify.ts

```ts
import Vue3Toastify, { toast } from 'vue3-toastify';
import 'vue3-toastify/dist/index.css';

export default defineNuxtPlugin((nuxtApp) => {
  nuxtApp.vueApp.use(Vue3Toastify, { autoClose: 1000 });

  return {
    provide: { toast },
  };
});

```

- demo.vue

```html
<script setup>
// import { toast } from 'vue3-toastify';

nextTick(() => {
  if (process.client) {
    useNuxtApp().$toast('notify after nextTick');
  }
});

const notify = () => {
  useNuxtApp().$toast.info('toastify success');
  // or
  // toast.info('toastify success');
};
</script>

<template>
  <button @click="notify">notify by click</button>
</template>
```

## Using the ES Module Build

[jsfiddle demo](https://jsfiddle.net/jerrywu001/r42xous5/)

```html
<html lang="en">
<head>
  <link href="https://cdn.jsdelivr.net/npm/vue3-toastify@0.1.13/dist/index.css" rel="stylesheet" />
  <title>Using the ES Module Build</title>
</head>
<body>
  <div id="app">
    <button @click="notify">show toast</button>
  </div>
  <script type="module">
    import { createApp } from 'https://unpkg.com/vue@3/dist/vue.esm-browser.js'
    import { toast } from 'https://cdn.jsdelivr.net/npm/vue3-toastify@0.1.13/+esm';

    createApp({
      methods: {
        notify() {
          toast.info('hello', { rtl: true });
        },
      }
    }).mount('#app')
  </script>
</body>
</html>
```

## Sponsors

<p align="center">
  <a href="https://ik.imagekit.io/jerrywu001/sponsors.svg?updatedAt=1691025797559">
    <img src="https://ik.imagekit.io/jerrywu001/sponsors.svg?updatedAt=1691025797559"/>
  </a>
</p>
