import "./chunk-JYWRH6CQ.js";
import {
  Comment,
  computed,
  createBaseVNode,
  createCommentVNode,
  createElementBlock,
  defineComponent,
  guardReactiveProps,
  inject,
  markRaw,
  mergeProps,
  normalizeProps,
  onBeforeUnmount,
  onMounted,
  openBlock,
  provide,
  ref,
  renderSlot,
  toRef,
  vShow,
  watch,
  withDirectives
} from "./chunk-A563ID7W.js";
import "./chunk-ROME4SDB.js";

// node_modules/vue3-google-map/dist/index.es.js
(function() {
  "use strict";
  try {
    if (typeof document < "u") {
      var e = document.createElement("style");
      e.appendChild(document.createTextNode(".mapdiv[data-v-174b771e]{width:100%;height:100%}.info-window-wrapper[data-v-90174664]{display:none}.mapdiv .info-window-wrapper[data-v-90174664]{display:inline-block}.custom-marker-wrapper[data-v-2d2d343a]{display:none}.mapdiv .custom-marker-wrapper[data-v-2d2d343a]{display:inline-block}")), document.head.appendChild(e);
    }
  } catch (a) {
    console.error("vite-plugin-css-injected-by-js", a);
  }
})();
var qe = Object.defineProperty;
var Be = (n3, e, t) => e in n3 ? qe(n3, e, { enumerable: true, configurable: true, writable: true, value: t }) : n3[e] = t;
var se = (n3, e, t) => (Be(n3, typeof e != "symbol" ? e + "" : e, t), t);
var Z = Symbol("map");
var D = Symbol("api");
var xe = Symbol("marker");
var Le = Symbol("markerCluster");
var ee = Symbol("CustomMarker");
var Se = Symbol("mapTilesLoaded");
var q = [
  "click",
  "dblclick",
  "drag",
  "dragend",
  "dragstart",
  "mousedown",
  "mousemove",
  "mouseout",
  "mouseover",
  "mouseup",
  "rightclick"
];
function Fe(n3, e, t, s) {
  function r(o) {
    return o instanceof t ? o : new t(function(a) {
      a(o);
    });
  }
  return new (t || (t = Promise))(function(o, a) {
    function l(u) {
      try {
        d(s.next(u));
      } catch (c) {
        a(c);
      }
    }
    function i(u) {
      try {
        d(s.throw(u));
      } catch (c) {
        a(c);
      }
    }
    function d(u) {
      u.done ? o(u.value) : r(u.value).then(l, i);
    }
    d((s = s.apply(n3, e || [])).next());
  });
}
var Ve = function n(e, t) {
  if (e === t)
    return true;
  if (e && t && typeof e == "object" && typeof t == "object") {
    if (e.constructor !== t.constructor)
      return false;
    var s, r, o;
    if (Array.isArray(e)) {
      if (s = e.length, s != t.length)
        return false;
      for (r = s; r-- !== 0; )
        if (!n(e[r], t[r]))
          return false;
      return true;
    }
    if (e.constructor === RegExp)
      return e.source === t.source && e.flags === t.flags;
    if (e.valueOf !== Object.prototype.valueOf)
      return e.valueOf() === t.valueOf();
    if (e.toString !== Object.prototype.toString)
      return e.toString() === t.toString();
    if (o = Object.keys(e), s = o.length, s !== Object.keys(t).length)
      return false;
    for (r = s; r-- !== 0; )
      if (!Object.prototype.hasOwnProperty.call(t, o[r]))
        return false;
    for (r = s; r-- !== 0; ) {
      var a = o[r];
      if (!n(e[a], t[a]))
        return false;
    }
    return true;
  }
  return e !== e && t !== t;
};
var de = "__googleMapsScriptId";
var R;
(function(n3) {
  n3[n3.INITIALIZED = 0] = "INITIALIZED", n3[n3.LOADING = 1] = "LOADING", n3[n3.SUCCESS = 2] = "SUCCESS", n3[n3.FAILURE = 3] = "FAILURE";
})(R || (R = {}));
var T = class _T {
  /**
   * Creates an instance of Loader using [[LoaderOptions]]. No defaults are set
   * using this library, instead the defaults are set by the Google Maps
   * JavaScript API server.
   *
   * ```
   * const loader = Loader({apiKey, version: 'weekly', libraries: ['places']});
   * ```
   */
  constructor({ apiKey: e, authReferrerPolicy: t, channel: s, client: r, id: o = de, language: a, libraries: l = [], mapIds: i, nonce: d, region: u, retries: c = 3, url: h = "https://maps.googleapis.com/maps/api/js", version: p }) {
    if (this.callbacks = [], this.done = false, this.loading = false, this.errors = [], this.apiKey = e, this.authReferrerPolicy = t, this.channel = s, this.client = r, this.id = o || de, this.language = a, this.libraries = l, this.mapIds = i, this.nonce = d, this.region = u, this.retries = c, this.url = h, this.version = p, _T.instance) {
      if (!Ve(this.options, _T.instance.options))
        throw new Error(`Loader must not be called again with different options. ${JSON.stringify(this.options)} !== ${JSON.stringify(_T.instance.options)}`);
      return _T.instance;
    }
    _T.instance = this;
  }
  get options() {
    return {
      version: this.version,
      apiKey: this.apiKey,
      channel: this.channel,
      client: this.client,
      id: this.id,
      libraries: this.libraries,
      language: this.language,
      region: this.region,
      mapIds: this.mapIds,
      nonce: this.nonce,
      url: this.url,
      authReferrerPolicy: this.authReferrerPolicy
    };
  }
  get status() {
    return this.errors.length ? R.FAILURE : this.done ? R.SUCCESS : this.loading ? R.LOADING : R.INITIALIZED;
  }
  get failed() {
    return this.done && !this.loading && this.errors.length >= this.retries + 1;
  }
  /**
   * CreateUrl returns the Google Maps JavaScript API script url given the [[LoaderOptions]].
   *
   * @ignore
   * @deprecated
   */
  createUrl() {
    let e = this.url;
    return e += "?callback=__googleMapsCallback", this.apiKey && (e += `&key=${this.apiKey}`), this.channel && (e += `&channel=${this.channel}`), this.client && (e += `&client=${this.client}`), this.libraries.length > 0 && (e += `&libraries=${this.libraries.join(",")}`), this.language && (e += `&language=${this.language}`), this.region && (e += `&region=${this.region}`), this.version && (e += `&v=${this.version}`), this.mapIds && (e += `&map_ids=${this.mapIds.join(",")}`), this.authReferrerPolicy && (e += `&auth_referrer_policy=${this.authReferrerPolicy}`), e;
  }
  deleteScript() {
    const e = document.getElementById(this.id);
    e && e.remove();
  }
  /**
   * Load the Google Maps JavaScript API script and return a Promise.
   * @deprecated, use importLibrary() instead.
   */
  load() {
    return this.loadPromise();
  }
  /**
   * Load the Google Maps JavaScript API script and return a Promise.
   *
   * @ignore
   * @deprecated, use importLibrary() instead.
   */
  loadPromise() {
    return new Promise((e, t) => {
      this.loadCallback((s) => {
        s ? t(s.error) : e(window.google);
      });
    });
  }
  importLibrary(e) {
    return this.execute(), google.maps.importLibrary(e);
  }
  /**
   * Load the Google Maps JavaScript API script with a callback.
   * @deprecated, use importLibrary() instead.
   */
  loadCallback(e) {
    this.callbacks.push(e), this.execute();
  }
  /**
   * Set the script on document.
   */
  setScript() {
    var e, t;
    if (document.getElementById(this.id)) {
      this.callback();
      return;
    }
    const s = {
      key: this.apiKey,
      channel: this.channel,
      client: this.client,
      libraries: this.libraries.length && this.libraries,
      v: this.version,
      mapIds: this.mapIds,
      language: this.language,
      region: this.region,
      authReferrerPolicy: this.authReferrerPolicy
    };
    Object.keys(s).forEach(
      // eslint-disable-next-line @typescript-eslint/no-explicit-any
      (o) => !s[o] && delete s[o]
    ), !((t = (e = window == null ? void 0 : window.google) === null || e === void 0 ? void 0 : e.maps) === null || t === void 0) && t.importLibrary || ((o) => {
      let a, l, i, d = "The Google Maps JavaScript API", u = "google", c = "importLibrary", h = "__ib__", p = document, m = window;
      m = m[u] || (m[u] = {});
      const f = m.maps || (m.maps = {}), g = /* @__PURE__ */ new Set(), v = new URLSearchParams(), w = () => (
        // @ts-ignore
        a || (a = new Promise((_, E) => Fe(this, void 0, void 0, function* () {
          var b;
          yield l = p.createElement("script"), l.id = this.id, v.set("libraries", [...g] + "");
          for (i in o)
            v.set(i.replace(/[A-Z]/g, (x) => "_" + x[0].toLowerCase()), o[i]);
          v.set("callback", u + ".maps." + h), l.src = this.url + "?" + v, f[h] = _, l.onerror = () => a = E(Error(d + " could not load.")), l.nonce = this.nonce || ((b = p.querySelector("script[nonce]")) === null || b === void 0 ? void 0 : b.nonce) || "", p.head.append(l);
        })))
      );
      f[c] ? console.warn(d + " only loads once. Ignoring:", o) : f[c] = (_, ...E) => g.add(_) && w().then(() => f[c](_, ...E));
    })(s);
    const r = this.libraries.map((o) => this.importLibrary(o));
    r.length || r.push(this.importLibrary("core")), Promise.all(r).then(() => this.callback(), (o) => {
      const a = new ErrorEvent("error", { error: o });
      this.loadErrorCallback(a);
    });
  }
  /**
   * Reset the loader state.
   */
  reset() {
    this.deleteScript(), this.done = false, this.loading = false, this.errors = [], this.onerrorEvent = null;
  }
  resetIfRetryingFailed() {
    this.failed && this.reset();
  }
  loadErrorCallback(e) {
    if (this.errors.push(e), this.errors.length <= this.retries) {
      const t = this.errors.length * Math.pow(2, this.errors.length);
      console.error(`Failed to load Google Maps script, retrying in ${t} ms.`), setTimeout(() => {
        this.deleteScript(), this.setScript();
      }, t);
    } else
      this.onerrorEvent = e, this.callback();
  }
  callback() {
    this.done = true, this.loading = false, this.callbacks.forEach((e) => {
      e(this.onerrorEvent);
    }), this.callbacks = [];
  }
  execute() {
    if (this.resetIfRetryingFailed(), this.done)
      this.callback();
    else {
      if (window.google && window.google.maps && window.google.maps.version) {
        console.warn("Google Maps already loaded outside @googlemaps/js-api-loader.This may result in undesirable behavior as options and script parameters may not match."), this.callback();
        return;
      }
      this.loading || (this.loading = true, this.setScript());
    }
  }
};
function ze(n3) {
  return class extends n3.OverlayView {
    constructor(s) {
      super();
      se(this, "element");
      se(this, "opts");
      const { element: r, ...o } = s;
      this.element = r, this.opts = o, this.opts.map && this.setMap(this.opts.map);
    }
    getPosition() {
      return this.opts.position ? this.opts.position instanceof n3.LatLng ? this.opts.position : new n3.LatLng(this.opts.position) : null;
    }
    getVisible() {
      if (!this.element)
        return false;
      const s = this.element;
      return s.style.display !== "none" && s.style.visibility !== "hidden" && (s.style.opacity === "" || Number(s.style.opacity) > 0.01);
    }
    onAdd() {
      if (!this.element)
        return;
      const s = this.getPanes();
      s && s.overlayMouseTarget.appendChild(this.element);
    }
    draw() {
      if (!this.element)
        return;
      const s = this.getProjection(), r = s == null ? void 0 : s.fromLatLngToDivPixel(this.getPosition());
      if (r) {
        this.element.style.position = "absolute";
        const o = this.element.offsetHeight, a = this.element.offsetWidth;
        let l, i;
        switch (this.opts.anchorPoint) {
          case "TOP_CENTER":
            l = r.x - a / 2, i = r.y;
            break;
          case "BOTTOM_CENTER":
            l = r.x - a / 2, i = r.y - o;
            break;
          case "LEFT_CENTER":
            l = r.x, i = r.y - o / 2;
            break;
          case "RIGHT_CENTER":
            l = r.x - a, i = r.y - o / 2;
            break;
          case "TOP_LEFT":
            l = r.x, i = r.y;
            break;
          case "TOP_RIGHT":
            l = r.x - a, i = r.y;
            break;
          case "BOTTOM_LEFT":
            l = r.x, i = r.y - o;
            break;
          case "BOTTOM_RIGHT":
            l = r.x - a, i = r.y - o;
            break;
          default:
            l = r.x - a / 2, i = r.y - o / 2;
        }
        this.element.style.left = l + "px", this.element.style.top = i + "px", this.element.style.transform = `translateX(${this.opts.offsetX || 0}px) translateY(${this.opts.offsetY || 0}px)`, this.opts.zIndex && (this.element.style.zIndex = this.opts.zIndex.toString());
      }
    }
    onRemove() {
      this.element && this.element.remove();
    }
    setOptions(s) {
      const { element: r, ...o } = s;
      this.element = r, this.opts = o, this.draw();
    }
  };
}
var he;
var pe = [
  "bounds_changed",
  "center_changed",
  "click",
  "dblclick",
  "drag",
  "dragend",
  "dragstart",
  "heading_changed",
  "idle",
  "maptypeid_changed",
  "mousemove",
  "mouseout",
  "mouseover",
  "projection_changed",
  "resize",
  "rightclick",
  "tilesloaded",
  "tilt_changed",
  "zoom_changed"
];
var Ge = defineComponent({
  props: {
    apiPromise: {
      type: Promise
    },
    apiKey: {
      type: String,
      default: ""
    },
    version: {
      type: String,
      default: "weekly"
    },
    libraries: {
      type: Array,
      default: () => ["places"]
    },
    region: {
      type: String,
      required: false
    },
    language: {
      type: String,
      required: false
    },
    backgroundColor: {
      type: String,
      required: false
    },
    center: {
      type: Object,
      default: () => ({ lat: 0, lng: 0 })
    },
    clickableIcons: {
      type: Boolean,
      required: false,
      default: void 0
    },
    controlSize: {
      type: Number,
      required: false
    },
    disableDefaultUi: {
      type: Boolean,
      required: false,
      default: void 0
    },
    disableDoubleClickZoom: {
      type: Boolean,
      required: false,
      default: void 0
    },
    draggable: {
      type: Boolean,
      required: false,
      default: void 0
    },
    draggableCursor: {
      type: String,
      required: false
    },
    draggingCursor: {
      type: String,
      required: false
    },
    fullscreenControl: {
      type: Boolean,
      required: false,
      default: void 0
    },
    fullscreenControlPosition: {
      type: String,
      required: false
    },
    gestureHandling: {
      type: String,
      required: false
    },
    heading: {
      type: Number,
      required: false
    },
    keyboardShortcuts: {
      type: Boolean,
      required: false,
      default: void 0
    },
    mapTypeControl: {
      type: Boolean,
      required: false,
      default: void 0
    },
    mapTypeControlOptions: {
      type: Object,
      required: false
    },
    mapTypeId: {
      type: [Number, String],
      required: false
    },
    mapId: {
      type: String,
      required: false
    },
    maxZoom: {
      type: Number,
      required: false
    },
    minZoom: {
      type: Number,
      required: false
    },
    noClear: {
      type: Boolean,
      required: false,
      default: void 0
    },
    panControl: {
      type: Boolean,
      required: false,
      default: void 0
    },
    panControlPosition: {
      type: String,
      required: false
    },
    restriction: {
      type: Object,
      required: false
    },
    rotateControl: {
      type: Boolean,
      required: false,
      default: void 0
    },
    rotateControlPosition: {
      type: String,
      required: false
    },
    scaleControl: {
      type: Boolean,
      required: false,
      default: void 0
    },
    scaleControlStyle: {
      type: Number,
      required: false
    },
    scrollwheel: {
      type: Boolean,
      required: false,
      default: void 0
    },
    streetView: {
      type: Object,
      required: false
    },
    streetViewControl: {
      type: Boolean,
      required: false,
      default: void 0
    },
    streetViewControlPosition: {
      type: String,
      required: false
    },
    styles: {
      type: Array,
      required: false
    },
    tilt: {
      type: Number,
      required: false
    },
    zoom: {
      type: Number,
      required: false
    },
    zoomControl: {
      type: Boolean,
      required: false,
      default: void 0
    },
    zoomControlPosition: {
      type: String,
      required: false
    }
  },
  emits: pe,
  setup(n3, { emit: e }) {
    const t = ref(), s = ref(false), r = ref(), o = ref(), a = ref(false);
    provide(Z, r), provide(D, o), provide(Se, a);
    const l = () => {
      const c = { ...n3 };
      Object.keys(c).forEach((f) => {
        c[f] === void 0 && delete c[f];
      });
      const p = (f) => {
        var g;
        return f ? { position: (g = o.value) == null ? void 0 : g.ControlPosition[f] } : {};
      }, m = {
        scaleControlOptions: n3.scaleControlStyle ? { style: n3.scaleControlStyle } : {},
        panControlOptions: p(n3.panControlPosition),
        zoomControlOptions: p(n3.zoomControlPosition),
        rotateControlOptions: p(n3.rotateControlPosition),
        streetViewControlOptions: p(n3.streetViewControlPosition),
        fullscreenControlOptions: p(n3.fullscreenControlPosition),
        disableDefaultUI: n3.disableDefaultUi
      };
      return { ...c, ...m };
    }, i = watch(
      [o, r],
      ([c, h]) => {
        const p = c, m = h;
        p && m && (p.event.addListenerOnce(m, "tilesloaded", () => {
          a.value = true;
        }), setTimeout(i, 0));
      },
      { immediate: true }
    ), d = () => {
      try {
        const { apiKey: c, region: h, version: p, language: m, libraries: f } = n3;
        he = new T({ apiKey: c, region: h, version: p, language: m, libraries: f });
      } catch (c) {
        console.error(c);
      }
    }, u = (c) => {
      o.value = markRaw(c.maps), r.value = markRaw(new c.maps.Map(t.value, l()));
      const h = ze(o.value);
      o.value[ee] = h, pe.forEach((m) => {
        var f;
        (f = r.value) == null || f.addListener(m, (g) => e(m, g));
      }), s.value = true;
      const p = Object.keys(n3).filter(
        (m) => !["apiPromise", "apiKey", "version", "libraries", "region", "language", "center", "zoom"].includes(m)
      ).map((m) => toRef(n3, m));
      watch(
        [() => n3.center, () => n3.zoom, ...p],
        ([m, f], [g, v]) => {
          var x, M, F;
          const { center: w, zoom: _, ...E } = l();
          (x = r.value) == null || x.setOptions(E), f !== void 0 && f !== v && ((M = r.value) == null || M.setZoom(f));
          const b = !g || m.lng !== g.lng || m.lat !== g.lat;
          m && b && ((F = r.value) == null || F.panTo(m));
        }
      );
    };
    return onMounted(() => {
      n3.apiPromise && n3.apiPromise instanceof Promise ? n3.apiPromise.then(u) : (d(), he.load().then(u));
    }), onBeforeUnmount(() => {
      var c;
      a.value = false, r.value && ((c = o.value) == null || c.event.clearInstanceListeners(r.value));
    }), { mapRef: t, ready: s, map: r, api: o, mapTilesLoaded: a };
  }
});
var te = (n3, e) => {
  const t = n3.__vccOpts || n3;
  for (const [s, r] of e)
    t[s] = r;
  return t;
};
var He = {
  ref: "mapRef",
  class: "mapdiv"
};
function We(n3, e, t, s, r, o) {
  return openBlock(), createElementBlock("div", null, [
    createBaseVNode("div", He, null, 512),
    renderSlot(n3.$slots, "default", normalizeProps(guardReactiveProps({ ready: n3.ready, map: n3.map, api: n3.api, mapTilesLoaded: n3.mapTilesLoaded })), void 0, true)
  ]);
}
var Ot = te(Ge, [["render", We], ["__scopeId", "data-v-174b771e"]]);
function Ke(n3) {
  return n3 && n3.__esModule && Object.prototype.hasOwnProperty.call(n3, "default") ? n3.default : n3;
}
var Je = function n2(e, t) {
  if (e === t)
    return true;
  if (e && t && typeof e == "object" && typeof t == "object") {
    if (e.constructor !== t.constructor)
      return false;
    var s, r, o;
    if (Array.isArray(e)) {
      if (s = e.length, s != t.length)
        return false;
      for (r = s; r-- !== 0; )
        if (!n2(e[r], t[r]))
          return false;
      return true;
    }
    if (e.constructor === RegExp)
      return e.source === t.source && e.flags === t.flags;
    if (e.valueOf !== Object.prototype.valueOf)
      return e.valueOf() === t.valueOf();
    if (e.toString !== Object.prototype.toString)
      return e.toString() === t.toString();
    if (o = Object.keys(e), s = o.length, s !== Object.keys(t).length)
      return false;
    for (r = s; r-- !== 0; )
      if (!Object.prototype.hasOwnProperty.call(t, o[r]))
        return false;
    for (r = s; r-- !== 0; ) {
      var a = o[r];
      if (!n2(e[a], t[a]))
        return false;
    }
    return true;
  }
  return e !== e && t !== t;
};
var $ = Ke(Je);
var Ye = (n3) => n3 === "Marker";
var Xe = (n3) => n3 === ee;
var U = (n3, e, t, s) => {
  const r = ref(), o = inject(Z, ref()), a = inject(D, ref()), l = inject(Le, ref()), i = computed(
    () => !!(l.value && a.value && (r.value instanceof a.value.Marker || r.value instanceof a.value[ee]))
  );
  return watch(
    [o, t],
    (d, [u, c]) => {
      var p, m, f;
      const h = !$(t.value, c) || o.value !== u;
      !o.value || !a.value || !h || (r.value ? (r.value.setOptions(t.value), i.value && ((p = l.value) == null || p.removeMarker(r.value), (m = l.value) == null || m.addMarker(r.value))) : (Ye(n3) ? r.value = markRaw(
        new a.value[n3](t.value)
      ) : Xe(n3) ? r.value = markRaw(
        new a.value[n3](t.value)
      ) : r.value = markRaw(
        new a.value[n3]({
          ...t.value,
          map: o.value
        })
      ), i.value ? (f = l.value) == null || f.addMarker(r.value) : r.value.setMap(o.value), e.forEach((g) => {
        var v;
        (v = r.value) == null || v.addListener(g, (w) => s(g, w));
      })));
    },
    {
      immediate: true
    }
  ), onBeforeUnmount(() => {
    var d, u;
    r.value && ((d = a.value) == null || d.event.clearInstanceListeners(r.value), i.value ? (u = l.value) == null || u.removeMarker(r.value) : r.value.setMap(null));
  }), r;
};
var fe = [
  "animation_changed",
  "click",
  "dblclick",
  "rightclick",
  "dragstart",
  "dragend",
  "drag",
  "mouseover",
  "mousedown",
  "mouseout",
  "mouseup",
  "draggable_changed",
  "clickable_changed",
  "contextmenu",
  "cursor_changed",
  "flat_changed",
  "rightclick",
  "zindex_changed",
  "icon_changed",
  "position_changed",
  "shape_changed",
  "title_changed",
  "visible_changed"
];
var xt = defineComponent({
  name: "Marker",
  props: {
    options: {
      type: Object,
      required: true
    }
  },
  emits: fe,
  setup(n3, { emit: e, expose: t, slots: s }) {
    const r = toRef(n3, "options"), o = U("Marker", fe, r, e);
    return provide(xe, o), t({ marker: o }), () => {
      var a;
      return (a = s.default) == null ? void 0 : a.call(s);
    };
  }
});
var Lt = defineComponent({
  name: "Polyline",
  props: {
    options: {
      type: Object,
      required: true
    }
  },
  emits: q,
  setup(n3, { emit: e }) {
    const t = toRef(n3, "options");
    return { polyline: U("Polyline", q, t, e) };
  },
  render: () => null
});
var St = defineComponent({
  name: "Polygon",
  props: {
    options: {
      type: Object,
      required: true
    }
  },
  emits: q,
  setup(n3, { emit: e }) {
    const t = toRef(n3, "options");
    return { polygon: U("Polygon", q, t, e) };
  },
  render: () => null
});
var me = q.concat(["bounds_changed"]);
var It = defineComponent({
  name: "Rectangle",
  props: {
    options: {
      type: Object,
      required: true
    }
  },
  emits: me,
  setup(n3, { emit: e }) {
    const t = toRef(n3, "options");
    return { rectangle: U("Rectangle", me, t, e) };
  },
  render: () => null
});
var ge = q.concat(["center_changed", "radius_changed"]);
var At = defineComponent({
  name: "Circle",
  props: {
    options: {
      type: Object,
      required: true
    }
  },
  emits: ge,
  setup(n3, { emit: e }) {
    const t = toRef(n3, "options");
    return { circle: U("Circle", ge, t, e) };
  },
  render: () => null
});
var Qe = defineComponent({
  props: {
    position: {
      type: String,
      required: true
    },
    index: {
      type: Number,
      default: 1
    }
  },
  emits: ["content:loaded"],
  setup(n3, { emit: e }) {
    const t = ref(null), s = inject(Z, ref()), r = inject(D, ref()), o = inject(Se, ref(false)), a = ref(false), l = watch(
      [o, r, t],
      ([u, c, h]) => {
        c && u && h && (i(n3.position), a.value = true, e("content:loaded"), setTimeout(l, 0));
      },
      { immediate: true }
    ), i = (u) => {
      if (s.value && r.value && t.value) {
        const c = r.value.ControlPosition[u];
        s.value.controls[c].push(t.value);
      }
    }, d = (u) => {
      if (s.value && r.value) {
        let c = null;
        const h = r.value.ControlPosition[u];
        s.value.controls[h].forEach((p, m) => {
          p === t.value && (c = m);
        }), c !== null && s.value.controls[h].removeAt(c);
      }
    };
    return onBeforeUnmount(() => d(n3.position)), watch(
      () => n3.position,
      (u, c) => {
        d(c), i(u);
      }
    ), watch(
      () => n3.index,
      (u) => {
        u && t.value && (t.value.index = n3.index);
      }
    ), { controlRef: t, showContent: a };
  }
});
var et = { ref: "controlRef" };
function tt(n3, e, t, s, r, o) {
  return withDirectives((openBlock(), createElementBlock("div", et, [
    renderSlot(n3.$slots, "default")
  ], 512)), [
    [vShow, n3.showContent]
  ]);
}
var Tt = te(Qe, [["render", tt]]);
var ve = ["closeclick", "content_changed", "domready", "position_changed", "visible", "zindex_changed"];
var st = defineComponent({
  inheritAttrs: false,
  props: {
    options: {
      type: Object,
      default: () => ({})
    },
    modelValue: {
      type: Boolean
    }
  },
  emits: [...ve, "update:modelValue"],
  setup(n3, { slots: e, emit: t, expose: s }) {
    const r = ref(), o = ref(), a = inject(Z, ref()), l = inject(D, ref()), i = inject(xe, ref());
    let d, u = n3.modelValue;
    const c = computed(() => {
      var f;
      return (f = e.default) == null ? void 0 : f.call(e).some((g) => g.type !== Comment);
    }), h = (f) => {
      u = f, t("update:modelValue", f);
    }, p = (f) => {
      r.value && (r.value.open({ map: a.value, anchor: i.value, ...f }), h(true));
    }, m = () => {
      r.value && (r.value.close(), h(false));
    };
    return onMounted(() => {
      watch(
        [a, () => n3.options],
        ([f, g], [v, w]) => {
          var E;
          const _ = !$(g, w) || a.value !== v;
          a.value && l.value && _ && (r.value ? (r.value.setOptions({
            ...g,
            content: c.value ? o.value : g.content
          }), i.value || p()) : (r.value = markRaw(
            new l.value.InfoWindow({
              ...g,
              content: c.value ? o.value : g.content
            })
          ), i.value && (d = i.value.addListener("click", () => {
            p();
          })), (!i.value || u) && p(), ve.forEach((b) => {
            var x;
            (x = r.value) == null || x.addListener(b, (M) => t(b, M));
          }), (E = r.value) == null || E.addListener("closeclick", () => h(false))));
        },
        {
          immediate: true
        }
      ), watch(() => n3.modelValue, (f) => {
        f !== u && (f ? p() : m());
      });
    }), onBeforeUnmount(() => {
      var f;
      d && d.remove(), r.value && ((f = l.value) == null || f.event.clearInstanceListeners(r.value), m());
    }), s({ infoWindow: r, open: p, close: m }), { infoWindow: r, infoWindowRef: o, hasSlotContent: c, open: p, close: m };
  }
});
var rt = {
  key: 0,
  class: "info-window-wrapper"
};
function nt(n3, e, t, s, r, o) {
  return n3.hasSlotContent ? (openBlock(), createElementBlock("div", rt, [
    createBaseVNode("div", mergeProps({ ref: "infoWindowRef" }, n3.$attrs), [
      renderSlot(n3.$slots, "default", {}, void 0, true)
    ], 16)
  ])) : createCommentVNode("", true);
}
var $t = te(st, [["render", nt], ["__scopeId", "data-v-90174664"]]);
var ye = [
  Int8Array,
  Uint8Array,
  Uint8ClampedArray,
  Int16Array,
  Uint16Array,
  Int32Array,
  Uint32Array,
  Float32Array,
  Float64Array
];
var re = 1;
var V = 8;
var le = class _le {
  /**
   * Creates an index from raw `ArrayBuffer` data.
   * @param {ArrayBuffer} data
   */
  static from(e) {
    if (!(e instanceof ArrayBuffer))
      throw new Error("Data must be an instance of ArrayBuffer.");
    const [t, s] = new Uint8Array(e, 0, 2);
    if (t !== 219)
      throw new Error("Data does not appear to be in a KDBush format.");
    const r = s >> 4;
    if (r !== re)
      throw new Error(`Got v${r} data when expected v${re}.`);
    const o = ye[s & 15];
    if (!o)
      throw new Error("Unrecognized array type.");
    const [a] = new Uint16Array(e, 2, 1), [l] = new Uint32Array(e, 4, 1);
    return new _le(l, a, o, e);
  }
  /**
   * Creates an index that will hold a given number of items.
   * @param {number} numItems
   * @param {number} [nodeSize=64] Size of the KD-tree node (64 by default).
   * @param {TypedArrayConstructor} [ArrayType=Float64Array] The array type used for coordinates storage (`Float64Array` by default).
   * @param {ArrayBuffer} [data] (For internal use only)
   */
  constructor(e, t = 64, s = Float64Array, r) {
    if (isNaN(e) || e < 0)
      throw new Error(`Unpexpected numItems value: ${e}.`);
    this.numItems = +e, this.nodeSize = Math.min(Math.max(+t, 2), 65535), this.ArrayType = s, this.IndexArrayType = e < 65536 ? Uint16Array : Uint32Array;
    const o = ye.indexOf(this.ArrayType), a = e * 2 * this.ArrayType.BYTES_PER_ELEMENT, l = e * this.IndexArrayType.BYTES_PER_ELEMENT, i = (8 - l % 8) % 8;
    if (o < 0)
      throw new Error(`Unexpected typed array class: ${s}.`);
    r && r instanceof ArrayBuffer ? (this.data = r, this.ids = new this.IndexArrayType(this.data, V, e), this.coords = new this.ArrayType(this.data, V + l + i, e * 2), this._pos = e * 2, this._finished = true) : (this.data = new ArrayBuffer(V + a + l + i), this.ids = new this.IndexArrayType(this.data, V, e), this.coords = new this.ArrayType(this.data, V + l + i, e * 2), this._pos = 0, this._finished = false, new Uint8Array(this.data, 0, 2).set([219, (re << 4) + o]), new Uint16Array(this.data, 2, 1)[0] = t, new Uint32Array(this.data, 4, 1)[0] = e);
  }
  /**
   * Add a point to the index.
   * @param {number} x
   * @param {number} y
   * @returns {number} An incremental index associated with the added item (starting from `0`).
   */
  add(e, t) {
    const s = this._pos >> 1;
    return this.ids[s] = s, this.coords[this._pos++] = e, this.coords[this._pos++] = t, s;
  }
  /**
   * Perform indexing of the added points.
   */
  finish() {
    const e = this._pos >> 1;
    if (e !== this.numItems)
      throw new Error(`Added ${e} items when expected ${this.numItems}.`);
    return ie(this.ids, this.coords, this.nodeSize, 0, this.numItems - 1, 0), this._finished = true, this;
  }
  /**
   * Search the index for items within a given bounding box.
   * @param {number} minX
   * @param {number} minY
   * @param {number} maxX
   * @param {number} maxY
   * @returns {number[]} An array of indices correponding to the found items.
   */
  range(e, t, s, r) {
    if (!this._finished)
      throw new Error("Data not yet indexed - call index.finish().");
    const { ids: o, coords: a, nodeSize: l } = this, i = [0, o.length - 1, 0], d = [];
    for (; i.length; ) {
      const u = i.pop() || 0, c = i.pop() || 0, h = i.pop() || 0;
      if (c - h <= l) {
        for (let g = h; g <= c; g++) {
          const v = a[2 * g], w = a[2 * g + 1];
          v >= e && v <= s && w >= t && w <= r && d.push(o[g]);
        }
        continue;
      }
      const p = h + c >> 1, m = a[2 * p], f = a[2 * p + 1];
      m >= e && m <= s && f >= t && f <= r && d.push(o[p]), (u === 0 ? e <= m : t <= f) && (i.push(h), i.push(p - 1), i.push(1 - u)), (u === 0 ? s >= m : r >= f) && (i.push(p + 1), i.push(c), i.push(1 - u));
    }
    return d;
  }
  /**
   * Search the index for items within a given radius.
   * @param {number} qx
   * @param {number} qy
   * @param {number} r Query radius.
   * @returns {number[]} An array of indices correponding to the found items.
   */
  within(e, t, s) {
    if (!this._finished)
      throw new Error("Data not yet indexed - call index.finish().");
    const { ids: r, coords: o, nodeSize: a } = this, l = [0, r.length - 1, 0], i = [], d = s * s;
    for (; l.length; ) {
      const u = l.pop() || 0, c = l.pop() || 0, h = l.pop() || 0;
      if (c - h <= a) {
        for (let g = h; g <= c; g++)
          we(o[2 * g], o[2 * g + 1], e, t) <= d && i.push(r[g]);
        continue;
      }
      const p = h + c >> 1, m = o[2 * p], f = o[2 * p + 1];
      we(m, f, e, t) <= d && i.push(r[p]), (u === 0 ? e - s <= m : t - s <= f) && (l.push(h), l.push(p - 1), l.push(1 - u)), (u === 0 ? e + s >= m : t + s >= f) && (l.push(p + 1), l.push(c), l.push(1 - u));
    }
    return i;
  }
};
function ie(n3, e, t, s, r, o) {
  if (r - s <= t)
    return;
  const a = s + r >> 1;
  Ie(n3, e, a, s, r, o), ie(n3, e, t, s, a - 1, 1 - o), ie(n3, e, t, a + 1, r, 1 - o);
}
function Ie(n3, e, t, s, r, o) {
  for (; r > s; ) {
    if (r - s > 600) {
      const d = r - s + 1, u = t - s + 1, c = Math.log(d), h = 0.5 * Math.exp(2 * c / 3), p = 0.5 * Math.sqrt(c * h * (d - h) / d) * (u - d / 2 < 0 ? -1 : 1), m = Math.max(s, Math.floor(t - u * h / d + p)), f = Math.min(r, Math.floor(t + (d - u) * h / d + p));
      Ie(n3, e, t, m, f, o);
    }
    const a = e[2 * t + o];
    let l = s, i = r;
    for (z(n3, e, s, t), e[2 * r + o] > a && z(n3, e, s, r); l < i; ) {
      for (z(n3, e, l, i), l++, i--; e[2 * l + o] < a; )
        l++;
      for (; e[2 * i + o] > a; )
        i--;
    }
    e[2 * s + o] === a ? z(n3, e, s, i) : (i++, z(n3, e, i, r)), i <= t && (s = i + 1), t <= i && (r = i - 1);
  }
}
function z(n3, e, t, s) {
  ne(n3, t, s), ne(e, 2 * t, 2 * s), ne(e, 2 * t + 1, 2 * s + 1);
}
function ne(n3, e, t) {
  const s = n3[e];
  n3[e] = n3[t], n3[t] = s;
}
function we(n3, e, t, s) {
  const r = n3 - t, o = e - s;
  return r * r + o * o;
}
var ot = {
  minZoom: 0,
  // min zoom to generate clusters on
  maxZoom: 16,
  // max zoom level to cluster the points on
  minPoints: 2,
  // minimum points to form a cluster
  radius: 40,
  // cluster radius in pixels
  extent: 512,
  // tile extent (radius is calculated relative to it)
  nodeSize: 64,
  // size of the KD-tree leaf node, affects performance
  log: false,
  // whether to log timing info
  // whether to generate numeric ids for input features (in vector tiles)
  generateId: false,
  // a reduce function for calculating custom cluster properties
  reduce: null,
  // (accumulated, props) => { accumulated.sum += props.sum; }
  // properties to use for individual points when running the reducer
  map: (n3) => n3
  // props => ({sum: props.my_value})
};
var _e = Math.fround || ((n3) => (e) => (n3[0] = +e, n3[0]))(new Float32Array(1));
var A = 2;
var S = 3;
var oe = 4;
var L = 5;
var Ae = 6;
var Te = class {
  constructor(e) {
    this.options = Object.assign(Object.create(ot), e), this.trees = new Array(this.options.maxZoom + 1), this.stride = this.options.reduce ? 7 : 6, this.clusterProps = [];
  }
  load(e) {
    const { log: t, minZoom: s, maxZoom: r } = this.options;
    t && console.time("total time");
    const o = `prepare ${e.length} points`;
    t && console.time(o), this.points = e;
    const a = [];
    for (let i = 0; i < e.length; i++) {
      const d = e[i];
      if (!d.geometry)
        continue;
      const [u, c] = d.geometry.coordinates, h = _e(W(u)), p = _e(K(c));
      a.push(
        h,
        p,
        // projected point coordinates
        1 / 0,
        // the last zoom the point was processed at
        i,
        // index of the source feature in the original input array
        -1,
        // parent cluster id
        1
        // number of points in a cluster
      ), this.options.reduce && a.push(0);
    }
    let l = this.trees[r + 1] = this._createTree(a);
    t && console.timeEnd(o);
    for (let i = r; i >= s; i--) {
      const d = +Date.now();
      l = this.trees[i] = this._createTree(this._cluster(l, i)), t && console.log("z%d: %d clusters in %dms", i, l.numItems, +Date.now() - d);
    }
    return t && console.timeEnd("total time"), this;
  }
  getClusters(e, t) {
    let s = ((e[0] + 180) % 360 + 360) % 360 - 180;
    const r = Math.max(-90, Math.min(90, e[1]));
    let o = e[2] === 180 ? 180 : ((e[2] + 180) % 360 + 360) % 360 - 180;
    const a = Math.max(-90, Math.min(90, e[3]));
    if (e[2] - e[0] >= 360)
      s = -180, o = 180;
    else if (s > o) {
      const c = this.getClusters([s, r, 180, a], t), h = this.getClusters([-180, r, o, a], t);
      return c.concat(h);
    }
    const l = this.trees[this._limitZoom(t)], i = l.range(W(s), K(a), W(o), K(r)), d = l.data, u = [];
    for (const c of i) {
      const h = this.stride * c;
      u.push(d[h + L] > 1 ? ke(d, h, this.clusterProps) : this.points[d[h + S]]);
    }
    return u;
  }
  getChildren(e) {
    const t = this._getOriginId(e), s = this._getOriginZoom(e), r = "No cluster with the specified id.", o = this.trees[s];
    if (!o)
      throw new Error(r);
    const a = o.data;
    if (t * this.stride >= a.length)
      throw new Error(r);
    const l = this.options.radius / (this.options.extent * Math.pow(2, s - 1)), i = a[t * this.stride], d = a[t * this.stride + 1], u = o.within(i, d, l), c = [];
    for (const h of u) {
      const p = h * this.stride;
      a[p + oe] === e && c.push(a[p + L] > 1 ? ke(a, p, this.clusterProps) : this.points[a[p + S]]);
    }
    if (c.length === 0)
      throw new Error(r);
    return c;
  }
  getLeaves(e, t, s) {
    t = t || 10, s = s || 0;
    const r = [];
    return this._appendLeaves(r, e, t, s, 0), r;
  }
  getTile(e, t, s) {
    const r = this.trees[this._limitZoom(e)], o = Math.pow(2, e), { extent: a, radius: l } = this.options, i = l / a, d = (s - i) / o, u = (s + 1 + i) / o, c = {
      features: []
    };
    return this._addTileFeatures(
      r.range((t - i) / o, d, (t + 1 + i) / o, u),
      r.data,
      t,
      s,
      o,
      c
    ), t === 0 && this._addTileFeatures(
      r.range(1 - i / o, d, 1, u),
      r.data,
      o,
      s,
      o,
      c
    ), t === o - 1 && this._addTileFeatures(
      r.range(0, d, i / o, u),
      r.data,
      -1,
      s,
      o,
      c
    ), c.features.length ? c : null;
  }
  getClusterExpansionZoom(e) {
    let t = this._getOriginZoom(e) - 1;
    for (; t <= this.options.maxZoom; ) {
      const s = this.getChildren(e);
      if (t++, s.length !== 1)
        break;
      e = s[0].properties.cluster_id;
    }
    return t;
  }
  _appendLeaves(e, t, s, r, o) {
    const a = this.getChildren(t);
    for (const l of a) {
      const i = l.properties;
      if (i && i.cluster ? o + i.point_count <= r ? o += i.point_count : o = this._appendLeaves(e, i.cluster_id, s, r, o) : o < r ? o++ : e.push(l), e.length === s)
        break;
    }
    return o;
  }
  _createTree(e) {
    const t = new le(e.length / this.stride | 0, this.options.nodeSize, Float32Array);
    for (let s = 0; s < e.length; s += this.stride)
      t.add(e[s], e[s + 1]);
    return t.finish(), t.data = e, t;
  }
  _addTileFeatures(e, t, s, r, o, a) {
    for (const l of e) {
      const i = l * this.stride, d = t[i + L] > 1;
      let u, c, h;
      if (d)
        u = $e(t, i, this.clusterProps), c = t[i], h = t[i + 1];
      else {
        const f = this.points[t[i + S]];
        u = f.properties;
        const [g, v] = f.geometry.coordinates;
        c = W(g), h = K(v);
      }
      const p = {
        type: 1,
        geometry: [[
          Math.round(this.options.extent * (c * o - s)),
          Math.round(this.options.extent * (h * o - r))
        ]],
        tags: u
      };
      let m;
      d || this.options.generateId ? m = t[i + S] : m = this.points[t[i + S]].id, m !== void 0 && (p.id = m), a.features.push(p);
    }
  }
  _limitZoom(e) {
    return Math.max(this.options.minZoom, Math.min(Math.floor(+e), this.options.maxZoom + 1));
  }
  _cluster(e, t) {
    const { radius: s, extent: r, reduce: o, minPoints: a } = this.options, l = s / (r * Math.pow(2, t)), i = e.data, d = [], u = this.stride;
    for (let c = 0; c < i.length; c += u) {
      if (i[c + A] <= t)
        continue;
      i[c + A] = t;
      const h = i[c], p = i[c + 1], m = e.within(i[c], i[c + 1], l), f = i[c + L];
      let g = f;
      for (const v of m) {
        const w = v * u;
        i[w + A] > t && (g += i[w + L]);
      }
      if (g > f && g >= a) {
        let v = h * f, w = p * f, _, E = -1;
        const b = ((c / u | 0) << 5) + (t + 1) + this.points.length;
        for (const x of m) {
          const M = x * u;
          if (i[M + A] <= t)
            continue;
          i[M + A] = t;
          const F = i[M + L];
          v += i[M] * F, w += i[M + 1] * F, i[M + oe] = b, o && (_ || (_ = this._map(i, c, true), E = this.clusterProps.length, this.clusterProps.push(_)), o(_, this._map(i, M)));
        }
        i[c + oe] = b, d.push(v / g, w / g, 1 / 0, b, -1, g), o && d.push(E);
      } else {
        for (let v = 0; v < u; v++)
          d.push(i[c + v]);
        if (g > 1)
          for (const v of m) {
            const w = v * u;
            if (!(i[w + A] <= t)) {
              i[w + A] = t;
              for (let _ = 0; _ < u; _++)
                d.push(i[w + _]);
            }
          }
      }
    }
    return d;
  }
  // get index of the point from which the cluster originated
  _getOriginId(e) {
    return e - this.points.length >> 5;
  }
  // get zoom of the point from which the cluster originated
  _getOriginZoom(e) {
    return (e - this.points.length) % 32;
  }
  _map(e, t, s) {
    if (e[t + L] > 1) {
      const a = this.clusterProps[e[t + Ae]];
      return s ? Object.assign({}, a) : a;
    }
    const r = this.points[e[t + S]].properties, o = this.options.map(r);
    return s && o === r ? Object.assign({}, o) : o;
  }
};
function ke(n3, e, t) {
  return {
    type: "Feature",
    id: n3[e + S],
    properties: $e(n3, e, t),
    geometry: {
      type: "Point",
      coordinates: [it(n3[e]), at(n3[e + 1])]
    }
  };
}
function $e(n3, e, t) {
  const s = n3[e + L], r = s >= 1e4 ? `${Math.round(s / 1e3)}k` : s >= 1e3 ? `${Math.round(s / 100) / 10}k` : s, o = n3[e + Ae], a = o === -1 ? {} : Object.assign({}, t[o]);
  return Object.assign(a, {
    cluster: true,
    cluster_id: n3[e + S],
    point_count: s,
    point_count_abbreviated: r
  });
}
function W(n3) {
  return n3 / 360 + 0.5;
}
function K(n3) {
  const e = Math.sin(n3 * Math.PI / 180), t = 0.5 - 0.25 * Math.log((1 + e) / (1 - e)) / Math.PI;
  return t < 0 ? 0 : t > 1 ? 1 : t;
}
function it(n3) {
  return (n3 - 0.5) * 360;
}
function at(n3) {
  const e = (180 - n3 * 360) * Math.PI / 180;
  return 360 * Math.atan(Math.exp(e)) / Math.PI - 90;
}
function ce(n3, e) {
  var t = {};
  for (var s in n3)
    Object.prototype.hasOwnProperty.call(n3, s) && e.indexOf(s) < 0 && (t[s] = n3[s]);
  if (n3 != null && typeof Object.getOwnPropertySymbols == "function")
    for (var r = 0, s = Object.getOwnPropertySymbols(n3); r < s.length; r++)
      e.indexOf(s[r]) < 0 && Object.prototype.propertyIsEnumerable.call(n3, s[r]) && (t[s[r]] = n3[s[r]]);
  return t;
}
var k = class {
  static isAdvancedMarkerAvailable(e) {
    return google.maps.marker && e.getMapCapabilities().isAdvancedMarkersAvailable === true;
  }
  static isAdvancedMarker(e) {
    return google.maps.marker && e instanceof google.maps.marker.AdvancedMarkerElement;
  }
  static setMap(e, t) {
    this.isAdvancedMarker(e) ? e.map = t : e.setMap(t);
  }
  static getPosition(e) {
    if (this.isAdvancedMarker(e)) {
      if (e.position) {
        if (e.position instanceof google.maps.LatLng)
          return e.position;
        if (e.position.lat && e.position.lng)
          return new google.maps.LatLng(e.position.lat, e.position.lng);
      }
      return new google.maps.LatLng(null);
    }
    return e.getPosition();
  }
  static getVisible(e) {
    return this.isAdvancedMarker(e) ? true : e.getVisible();
  }
};
var H = class {
  constructor({ markers: e, position: t }) {
    this.markers = e, t && (t instanceof google.maps.LatLng ? this._position = t : this._position = new google.maps.LatLng(t));
  }
  get bounds() {
    if (this.markers.length === 0 && !this._position)
      return;
    const e = new google.maps.LatLngBounds(this._position, this._position);
    for (const t of this.markers)
      e.extend(k.getPosition(t));
    return e;
  }
  get position() {
    return this._position || this.bounds.getCenter();
  }
  /**
   * Get the count of **visible** markers.
   */
  get count() {
    return this.markers.filter((e) => k.getVisible(e)).length;
  }
  /**
   * Add a marker to the cluster.
   */
  push(e) {
    this.markers.push(e);
  }
  /**
   * Cleanup references and remove marker from map.
   */
  delete() {
    this.marker && (k.setMap(this.marker, null), this.marker = void 0), this.markers.length = 0;
  }
};
var lt = (n3, e, t, s) => {
  const r = Re(n3.getBounds(), e, s);
  return t.filter((o) => r.contains(k.getPosition(o)));
};
var Re = (n3, e, t) => {
  const { northEast: s, southWest: r } = ct(n3, e), o = ut({ northEast: s, southWest: r }, t);
  return dt(o, e);
};
var Ce = (n3, e, t) => {
  const s = Re(n3, e, t), r = s.getNorthEast(), o = s.getSouthWest();
  return [o.lng(), o.lat(), r.lng(), r.lat()];
};
var ct = (n3, e) => ({
  northEast: e.fromLatLngToDivPixel(n3.getNorthEast()),
  southWest: e.fromLatLngToDivPixel(n3.getSouthWest())
});
var ut = ({ northEast: n3, southWest: e }, t) => (n3.x += t, n3.y -= t, e.x -= t, e.y += t, { northEast: n3, southWest: e });
var dt = ({ northEast: n3, southWest: e }, t) => {
  const s = t.fromDivPixelToLatLng(e), r = t.fromDivPixelToLatLng(n3);
  return new google.maps.LatLngBounds(s, r);
};
var je = class {
  constructor({ maxZoom: e = 16 }) {
    this.maxZoom = e;
  }
  /**
   * Helper function to bypass clustering based upon some map state such as
   * zoom, number of markers, etc.
   *
   * ```typescript
   *  cluster({markers, map}: AlgorithmInput): Cluster[] {
   *    if (shouldBypassClustering(map)) {
   *      return this.noop({markers})
   *    }
   * }
   * ```
   */
  noop({ markers: e }) {
    return pt(e);
  }
};
var ht = class extends je {
  constructor(e) {
    var { viewportPadding: t = 60 } = e, s = ce(e, ["viewportPadding"]);
    super(s), this.viewportPadding = 60, this.viewportPadding = t;
  }
  calculate({ markers: e, map: t, mapCanvasProjection: s }) {
    return t.getZoom() >= this.maxZoom ? {
      clusters: this.noop({
        markers: e
      }),
      changed: false
    } : {
      clusters: this.cluster({
        markers: lt(t, s, e, this.viewportPadding),
        map: t,
        mapCanvasProjection: s
      })
    };
  }
};
var pt = (n3) => n3.map((t) => new H({
  position: k.getPosition(t),
  markers: [t]
}));
var ft = class extends je {
  constructor(e) {
    var { maxZoom: t, radius: s = 60 } = e, r = ce(e, ["maxZoom", "radius"]);
    super({ maxZoom: t }), this.state = { zoom: -1 }, this.superCluster = new Te(Object.assign({ maxZoom: this.maxZoom, radius: s }, r));
  }
  calculate(e) {
    let t = false;
    const s = { zoom: e.map.getZoom() };
    if (!$(e.markers, this.markers)) {
      t = true, this.markers = [...e.markers];
      const r = this.markers.map((o) => {
        const a = k.getPosition(o);
        return {
          type: "Feature",
          geometry: {
            type: "Point",
            coordinates: [a.lng(), a.lat()]
          },
          properties: { marker: o }
        };
      });
      this.superCluster.load(r);
    }
    return t || (this.state.zoom <= this.maxZoom || s.zoom <= this.maxZoom) && (t = !$(this.state, s)), this.state = s, t && (this.clusters = this.cluster(e)), { clusters: this.clusters, changed: t };
  }
  cluster({ map: e }) {
    return this.superCluster.getClusters([-180, -90, 180, 90], Math.round(e.getZoom())).map((t) => this.transformCluster(t));
  }
  transformCluster({ geometry: { coordinates: [e, t] }, properties: s }) {
    if (s.cluster)
      return new H({
        markers: this.superCluster.getLeaves(s.cluster_id, 1 / 0).map((o) => o.properties.marker),
        position: { lat: t, lng: e }
      });
    const r = s.marker;
    return new H({
      markers: [r],
      position: k.getPosition(r)
    });
  }
};
var mt = class extends ht {
  constructor(e) {
    var { maxZoom: t, radius: s = 60, viewportPadding: r = 60 } = e, o = ce(e, ["maxZoom", "radius", "viewportPadding"]);
    super({ maxZoom: t, viewportPadding: r }), this.superCluster = new Te(Object.assign({ maxZoom: this.maxZoom, radius: s }, o)), this.state = { zoom: -1, view: [0, 0, 0, 0] };
  }
  calculate(e) {
    const t = {
      zoom: Math.round(e.map.getZoom()),
      view: Ce(e.map.getBounds(), e.mapCanvasProjection, this.viewportPadding)
    };
    let s = !$(this.state, t);
    if (!$(e.markers, this.markers)) {
      s = true, this.markers = [...e.markers];
      const r = this.markers.map((o) => {
        const a = k.getPosition(o);
        return {
          type: "Feature",
          geometry: {
            type: "Point",
            coordinates: [a.lng(), a.lat()]
          },
          properties: { marker: o }
        };
      });
      this.superCluster.load(r);
    }
    return s && (this.clusters = this.cluster(e), this.state = t), { clusters: this.clusters, changed: s };
  }
  cluster({ map: e, mapCanvasProjection: t }) {
    const s = {
      zoom: Math.round(e.getZoom()),
      view: Ce(e.getBounds(), t, this.viewportPadding)
    };
    return this.superCluster.getClusters(s.view, s.zoom).map((r) => this.transformCluster(r));
  }
  transformCluster({ geometry: { coordinates: [e, t] }, properties: s }) {
    if (s.cluster)
      return new H({
        markers: this.superCluster.getLeaves(s.cluster_id, 1 / 0).map((o) => o.properties.marker),
        position: { lat: t, lng: e }
      });
    const r = s.marker;
    return new H({
      markers: [r],
      position: k.getPosition(r)
    });
  }
};
var gt = class {
  constructor(e, t) {
    this.markers = { sum: e.length };
    const s = t.map((o) => o.count), r = s.reduce((o, a) => o + a, 0);
    this.clusters = {
      count: t.length,
      markers: {
        mean: r / t.length,
        sum: r,
        min: Math.min(...s),
        max: Math.max(...s)
      }
    };
  }
};
var vt = class {
  /**
   * The default render function for the library used by {@link MarkerClusterer}.
   *
   * Currently set to use the following:
   *
   * ```typescript
   * // change color if this cluster has more markers than the mean cluster
   * const color =
   *   count > Math.max(10, stats.clusters.markers.mean)
   *     ? "#ff0000"
   *     : "#0000ff";
   *
   * // create svg url with fill color
   * const svg = window.btoa(`
   * <svg fill="${color}" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 240 240">
   *   <circle cx="120" cy="120" opacity=".6" r="70" />
   *   <circle cx="120" cy="120" opacity=".3" r="90" />
   *   <circle cx="120" cy="120" opacity=".2" r="110" />
   *   <circle cx="120" cy="120" opacity=".1" r="130" />
   * </svg>`);
   *
   * // create marker using svg icon
   * return new google.maps.Marker({
   *   position,
   *   icon: {
   *     url: `data:image/svg+xml;base64,${svg}`,
   *     scaledSize: new google.maps.Size(45, 45),
   *   },
   *   label: {
   *     text: String(count),
   *     color: "rgba(255,255,255,0.9)",
   *     fontSize: "12px",
   *   },
   *   // adjust zIndex to be above other markers
   *   zIndex: 1000 + count,
   * });
   * ```
   */
  render({ count: e, position: t }, s, r) {
    const a = `<svg fill="${e > Math.max(10, s.clusters.markers.mean) ? "#ff0000" : "#0000ff"}" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 240 240" width="50" height="50">
<circle cx="120" cy="120" opacity=".6" r="70" />
<circle cx="120" cy="120" opacity=".3" r="90" />
<circle cx="120" cy="120" opacity=".2" r="110" />
<text x="50%" y="50%" style="fill:#fff" text-anchor="middle" font-size="50" dominant-baseline="middle" font-family="roboto,arial,sans-serif">${e}</text>
</svg>`, l = `Cluster of ${e} markers`, i = Number(google.maps.Marker.MAX_ZINDEX) + e;
    if (k.isAdvancedMarkerAvailable(r)) {
      const u = document.createElement("div");
      u.innerHTML = a;
      const c = u.firstElementChild;
      c.setAttribute("transform", "translate(0 25)");
      const h = {
        map: r,
        position: t,
        zIndex: i,
        title: l,
        content: c
      };
      return new google.maps.marker.AdvancedMarkerElement(h);
    }
    const d = {
      position: t,
      zIndex: i,
      title: l,
      icon: {
        url: `data:image/svg+xml;base64,${btoa(a)}`,
        anchor: new google.maps.Point(25, 25)
      }
    };
    return new google.maps.Marker(d);
  }
};
function yt(n3, e) {
  for (let t in e.prototype)
    n3.prototype[t] = e.prototype[t];
}
var ue = class _ue {
  constructor() {
    yt(_ue, google.maps.OverlayView);
  }
};
var j;
(function(n3) {
  n3.CLUSTERING_BEGIN = "clusteringbegin", n3.CLUSTERING_END = "clusteringend", n3.CLUSTER_CLICK = "click";
})(j || (j = {}));
var wt = (n3, e, t) => {
  t.fitBounds(e.bounds);
};
var _t = class extends ue {
  constructor({ map: e, markers: t = [], algorithmOptions: s = {}, algorithm: r = new ft(s), renderer: o = new vt(), onClusterClick: a = wt }) {
    super(), this.markers = [...t], this.clusters = [], this.algorithm = r, this.renderer = o, this.onClusterClick = a, e && this.setMap(e);
  }
  addMarker(e, t) {
    this.markers.includes(e) || (this.markers.push(e), t || this.render());
  }
  addMarkers(e, t) {
    e.forEach((s) => {
      this.addMarker(s, true);
    }), t || this.render();
  }
  removeMarker(e, t) {
    const s = this.markers.indexOf(e);
    return s === -1 ? false : (k.setMap(e, null), this.markers.splice(s, 1), t || this.render(), true);
  }
  removeMarkers(e, t) {
    let s = false;
    return e.forEach((r) => {
      s = this.removeMarker(r, true) || s;
    }), s && !t && this.render(), s;
  }
  clearMarkers(e) {
    this.markers.length = 0, e || this.render();
  }
  /**
   * Recalculates and draws all the marker clusters.
   */
  render() {
    const e = this.getMap();
    if (e instanceof google.maps.Map && e.getProjection()) {
      google.maps.event.trigger(this, j.CLUSTERING_BEGIN, this);
      const { clusters: t, changed: s } = this.algorithm.calculate({
        markers: this.markers,
        map: e,
        mapCanvasProjection: this.getProjection()
      });
      if (s || s == null) {
        const r = /* @__PURE__ */ new Set();
        for (const a of t)
          a.markers.length == 1 && r.add(a.markers[0]);
        const o = [];
        for (const a of this.clusters)
          a.marker != null && (a.markers.length == 1 ? r.has(a.marker) || k.setMap(a.marker, null) : o.push(a.marker));
        this.clusters = t, this.renderClusters(), requestAnimationFrame(() => o.forEach((a) => k.setMap(a, null)));
      }
      google.maps.event.trigger(this, j.CLUSTERING_END, this);
    }
  }
  onAdd() {
    this.idleListener = this.getMap().addListener("idle", this.render.bind(this)), this.render();
  }
  onRemove() {
    google.maps.event.removeListener(this.idleListener), this.reset();
  }
  reset() {
    this.markers.forEach((e) => k.setMap(e, null)), this.clusters.forEach((e) => e.delete()), this.clusters = [];
  }
  renderClusters() {
    const e = new gt(this.markers, this.clusters), t = this.getMap();
    this.clusters.forEach((s) => {
      s.markers.length === 1 ? s.marker = s.markers[0] : (s.marker = this.renderer.render(s, e, t), s.markers.forEach((r) => k.setMap(r, null)), this.onClusterClick && s.marker.addListener(
        "click",
        /* istanbul ignore next */
        (r) => {
          google.maps.event.trigger(this, j.CLUSTER_CLICK, s), this.onClusterClick(r, s, t);
        }
      )), k.setMap(s.marker, t);
    });
  }
};
var be = Object.values(j);
var Rt = defineComponent({
  name: "MarkerCluster",
  props: {
    options: {
      type: Object,
      default: () => ({})
    }
  },
  emits: be,
  setup(n3, { emit: e, expose: t, slots: s }) {
    const r = ref(), o = inject(Z, ref()), a = inject(D, ref());
    return provide(Le, r), watch(
      o,
      () => {
        o.value && (r.value = markRaw(
          new _t({
            map: o.value,
            // Better perf than the default `SuperClusterAlgorithm`. See:
            // https://github.com/googlemaps/js-markerclusterer/pull/640
            algorithm: new mt(n3.options.algorithmOptions ?? {}),
            ...n3.options
          })
        ), be.forEach((l) => {
          var i;
          (i = r.value) == null || i.addListener(l, (d) => e(l, d));
        }));
      },
      {
        immediate: true
      }
    ), onBeforeUnmount(() => {
      var l;
      r.value && ((l = a.value) == null || l.event.clearInstanceListeners(r.value), r.value.clearMarkers(), r.value.setMap(null));
    }), t({ markerCluster: r }), () => {
      var l;
      return (l = s.default) == null ? void 0 : l.call(s);
    };
  }
});
var kt = defineComponent({
  inheritAttrs: false,
  props: {
    options: {
      type: Object,
      required: true
    }
  },
  setup(n3, { slots: e, emit: t, expose: s }) {
    const r = ref(), o = computed(() => {
      var i;
      return (i = e.default) == null ? void 0 : i.call(e).some((d) => d.type !== Comment);
    }), a = computed(() => ({
      ...n3.options,
      element: r.value
    })), l = U(ee, [], a, t);
    return s({
      customMarker: l
    }), { customMarkerRef: r, customMarker: l, hasSlotContent: o };
  }
});
var Ct = {
  key: 0,
  class: "custom-marker-wrapper"
};
function bt(n3, e, t, s, r, o) {
  return n3.hasSlotContent ? (openBlock(), createElementBlock("div", Ct, [
    createBaseVNode("div", mergeProps({
      ref: "customMarkerRef",
      style: { cursor: n3.$attrs.onClick ? "pointer" : void 0 }
    }, n3.$attrs), [
      renderSlot(n3.$slots, "default", {}, void 0, true)
    ], 16)
  ])) : createCommentVNode("", true);
}
var jt = te(kt, [["render", bt], ["__scopeId", "data-v-2d2d343a"]]);
var qt = defineComponent({
  name: "HeatmapLayer",
  props: {
    options: {
      type: Object,
      default: () => ({})
    }
  },
  setup(n3) {
    const e = ref(), t = inject(Z, ref()), s = inject(D, ref());
    return watch(
      [t, () => n3.options],
      ([r, o], [a, l]) => {
        var d;
        const i = !$(o, l) || t.value !== a;
        if (t.value && s.value && i) {
          const u = structuredClone(o);
          if (u.data && !(u.data instanceof s.value.MVCArray)) {
            const c = s.value.LatLng;
            u.data = (d = u.data) == null ? void 0 : d.map((h) => h instanceof c || "location" in h && (h.location instanceof c || h.location === null) ? h : "location" in h ? { ...h, location: new c(h.location) } : new c(h));
          }
          e.value ? e.value.setOptions(u) : e.value = markRaw(
            new s.value.visualization.HeatmapLayer({
              ...u,
              map: t.value
            })
          );
        }
      },
      { immediate: true }
    ), onBeforeUnmount(() => {
      e.value && e.value.setMap(null);
    }), { heatmapLayer: e };
  },
  render: () => null
});
export {
  At as Circle,
  Tt as CustomControl,
  jt as CustomMarker,
  Ot as GoogleMap,
  qt as HeatmapLayer,
  $t as InfoWindow,
  xt as Marker,
  Rt as MarkerCluster,
  St as Polygon,
  Lt as Polyline,
  It as Rectangle
};
/*! Bundled license information:

vue3-google-map/dist/index.es.js:
  (*! *****************************************************************************
  Copyright (c) Microsoft Corporation.
  
  Permission to use, copy, modify, and/or distribute this software for any
  purpose with or without fee is hereby granted.
  
  THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
  REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
  AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
  INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
  LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
  OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
  PERFORMANCE OF THIS SOFTWARE.
  ***************************************************************************** *)
*/
//# sourceMappingURL=vue3-google-map.js.map
