import { resolveComponent as b, openBlock as r, createBlock as y, withCtx as k, createElementBlock as s, mergeProps as o, normalizeClass as v, createElementVNode as i, toHandlers as c, renderSlot as _, createCommentVNode as p, Fragment as R, renderList as C, createTextVNode as A, toDisplayString as U } from "vue";
const B = {
  emits: ["pagination-change-page"],
  props: {
    data: {
      type: Object,
      default: () => {
      }
    },
    limit: {
      type: Number,
      default: 0
    },
    keepLength: {
      type: Boolean,
      default: !1
    }
  },
  computed: {
    isApiResource() {
      return !!this.data.meta;
    },
    currentPage() {
      return this.isApiResource ? this.data.meta.current_page : this.data.current_page;
    },
    firstPageUrl() {
      return this.isApiResource ? this.data.links.first : null;
    },
    from() {
      return this.isApiResource ? this.data.meta.from : this.data.from;
    },
    lastPage() {
      return this.isApiResource ? this.data.meta.last_page : this.data.last_page;
    },
    lastPageUrl() {
      return this.isApiResource ? this.data.links.last : null;
    },
    nextPageUrl() {
      return this.isApiResource ? this.data.links.next : this.data.next_page_url;
    },
    perPage() {
      return this.isApiResource ? this.data.meta.per_page : this.data.per_page;
    },
    prevPageUrl() {
      return this.isApiResource ? this.data.links.prev : this.data.prev_page_url;
    },
    to() {
      return this.isApiResource ? this.data.meta.to : this.data.to;
    },
    total() {
      return this.isApiResource ? this.data.meta.total : this.data.total;
    },
    pageRange() {
      if (this.limit === -1)
        return 0;
      if (this.limit === 0)
        return this.lastPage;
      for (var t = this.currentPage, g = this.keepLength, a = this.lastPage, u = this.limit, f = t - u, m = t + u, h = (u + 2) * 2, e = (u + 2) * 2 - 1, n = [], d = [], P, l = 1; l <= a; l++)
        (l === 1 || l === a || l >= f && l <= m || g && l < h && t < h - 2 || g && l > a - e && t > a - e + 2) && n.push(l);
      return n.forEach(function(x) {
        P && (x - P === 2 ? d.push(P + 1) : x - P !== 1 && d.push("...")), d.push(x), P = x;
      }), d;
    }
  },
  methods: {
    previousPage() {
      this.selectPage(this.currentPage - 1);
    },
    nextPage() {
      this.selectPage(this.currentPage + 1);
    },
    selectPage(t) {
      t === "..." || t === this.currentPage || this.$emit("pagination-change-page", t);
    }
  },
  render() {
    return this.$slots.default({
      data: this.data,
      limit: this.limit,
      computed: {
        isApiResource: this.isApiResource,
        currentPage: this.currentPage,
        firstPageUrl: this.firstPageUrl,
        from: this.from,
        lastPage: this.lastPage,
        lastPageUrl: this.lastPageUrl,
        nextPageUrl: this.nextPageUrl,
        perPage: this.perPage,
        prevPageUrl: this.prevPageUrl,
        to: this.to,
        total: this.total,
        pageRange: this.pageRange
      },
      prevButtonEvents: {
        click: (t) => {
          t.preventDefault(), this.previousPage();
        }
      },
      nextButtonEvents: {
        click: (t) => {
          t.preventDefault(), this.nextPage();
        }
      },
      pageButtonEvents: (t) => ({
        click: (g) => {
          g.preventDefault(), this.selectPage(t);
        }
      })
    });
  }
}, w = (t, g) => {
  const a = t.__vccOpts || t;
  for (const [u, f] of g)
    a[u] = f;
  return a;
}, E = {
  compatConfig: {
    MODE: 3
  },
  inheritAttrs: !1,
  emits: ["pagination-change-page"],
  components: {
    RenderlessPagination: B
  },
  props: {
    data: {
      type: Object,
      default: () => {
      }
    },
    limit: {
      type: Number,
      default: 0
    },
    keepLength: {
      type: Boolean,
      default: !1
    },
    showDisabled: {
      type: Boolean,
      default: !1
    },
    size: {
      type: String,
      default: "default",
      validator: (t) => ["small", "default", "large"].indexOf(t) !== -1
    },
    align: {
      type: String,
      default: "left",
      validator: (t) => ["left", "center", "right"].indexOf(t) !== -1
    }
  },
  methods: {
    onPaginationChangePage(t) {
      this.$emit("pagination-change-page", t);
    }
  }
}, $ = ["tabindex"], D = /* @__PURE__ */ i("span", { "aria-hidden": "true" }, "\xAB", -1), z = /* @__PURE__ */ i("span", { class: "sr-only" }, "Previous", -1), O = {
  key: 0,
  class: "sr-only"
}, N = ["tabindex"], j = /* @__PURE__ */ i("span", { "aria-hidden": "true" }, "\xBB", -1), L = /* @__PURE__ */ i("span", { class: "sr-only" }, "Next", -1);
function S(t, g, a, u, f, m) {
  const h = b("RenderlessPagination");
  return r(), y(h, {
    data: a.data,
    limit: a.limit,
    "keep-length": a.keepLength,
    onPaginationChangePage: m.onPaginationChangePage
  }, {
    default: k((e) => [
      e.computed.total > e.computed.perPage ? (r(), s("ul", o({ key: 0 }, t.$attrs, {
        class: ["pagination", {
          "pagination-sm": a.size == "small",
          "pagination-lg": a.size == "large",
          "justify-content-center": a.align == "center",
          "justify-content-end": a.align == "right"
        }]
      }), [
        e.computed.prevPageUrl || a.showDisabled ? (r(), s("li", {
          key: 0,
          class: v(["page-item pagination-prev-nav", { disabled: !e.computed.prevPageUrl }])
        }, [
          i("a", o({
            class: "page-link",
            href: "#",
            "aria-label": "Previous",
            tabindex: !e.computed.prevPageUrl && -1
          }, c(e.prevButtonEvents, !0)), [
            _(t.$slots, "prev-nav", {}, () => [
              D,
              z
            ])
          ], 16, $)
        ], 2)) : p("", !0),
        (r(!0), s(R, null, C(e.computed.pageRange, (n, d) => (r(), s("li", {
          class: v(["page-item pagination-page-nav", { active: n == e.computed.currentPage }]),
          key: d
        }, [
          i("a", o({
            class: "page-link",
            href: "#"
          }, c(e.pageButtonEvents(n), !0)), [
            A(U(n) + " ", 1),
            n == e.computed.currentPage ? (r(), s("span", O, "(current)")) : p("", !0)
          ], 16)
        ], 2))), 128)),
        e.computed.nextPageUrl || a.showDisabled ? (r(), s("li", {
          key: 1,
          class: v(["page-item pagination-next-nav", { disabled: !e.computed.nextPageUrl }])
        }, [
          i("a", o({
            class: "page-link",
            href: "#",
            "aria-label": "Next",
            tabindex: !e.computed.nextPageUrl && -1
          }, c(e.nextButtonEvents, !0)), [
            _(t.$slots, "next-nav", {}, () => [
              j,
              L
            ])
          ], 16, N)
        ], 2)) : p("", !0)
      ], 16)) : p("", !0)
    ]),
    _: 3
  }, 8, ["data", "limit", "keep-length", "onPaginationChangePage"]);
}
const ae = /* @__PURE__ */ w(E, [["render", S]]), M = {
  compatConfig: {
    MODE: 3
  },
  inheritAttrs: !1,
  emits: ["pagination-change-page"],
  components: {
    RenderlessPagination: B
  },
  props: {
    data: {
      type: Object,
      default: () => {
      }
    },
    limit: {
      type: Number,
      default: 0
    },
    showDisabled: {
      type: Boolean,
      default: !1
    },
    keepLength: {
      type: Boolean,
      default: !1
    },
    size: {
      type: String,
      default: "default",
      validator: (t) => ["small", "default", "large"].indexOf(t) !== -1
    },
    align: {
      type: String,
      default: "left",
      validator: (t) => ["left", "center", "right"].indexOf(t) !== -1
    }
  },
  methods: {
    onPaginationChangePage(t) {
      this.$emit("pagination-change-page", t);
    }
  }
}, V = ["tabindex"], T = /* @__PURE__ */ i("span", { "aria-hidden": "true" }, "\xAB", -1), F = ["aria-current"], H = ["tabindex"], q = /* @__PURE__ */ i("span", { "aria-hidden": "true" }, "\xBB", -1);
function G(t, g, a, u, f, m) {
  const h = b("RenderlessPagination");
  return r(), y(h, {
    data: a.data,
    limit: a.limit,
    "keep-length": a.keepLength,
    onPaginationChangePage: m.onPaginationChangePage
  }, {
    default: k((e) => [
      e.computed.total > e.computed.perPage ? (r(), s("ul", o({ key: 0 }, t.$attrs, {
        class: ["pagination", {
          "pagination-sm": a.size == "small",
          "pagination-lg": a.size == "large",
          "justify-content-center": a.align == "center",
          "justify-content-end": a.align == "right"
        }]
      }), [
        e.computed.prevPageUrl || a.showDisabled ? (r(), s("li", {
          key: 0,
          class: v(["page-item pagination-prev-nav", { disabled: !e.computed.prevPageUrl }])
        }, [
          i("a", o({
            class: "page-link",
            href: "#",
            "aria-label": "Previous",
            tabindex: !e.computed.prevPageUrl && -1
          }, c(e.prevButtonEvents, !0)), [
            _(t.$slots, "prev-nav", {}, () => [
              T
            ])
          ], 16, V)
        ], 2)) : p("", !0),
        (r(!0), s(R, null, C(e.computed.pageRange, (n, d) => (r(), s("li", {
          class: v(["page-item pagination-page-nav", { active: n == e.computed.currentPage }]),
          key: d
        }, [
          i("a", o({
            class: "page-link",
            href: "#"
          }, c(e.pageButtonEvents(n), !0), {
            "aria-current": n == e.computed.currentPage ? "page" : null
          }), U(n), 17, F)
        ], 2))), 128)),
        e.computed.nextPageUrl || a.showDisabled ? (r(), s("li", {
          key: 1,
          class: v(["page-item pagination-next-nav", { disabled: !e.computed.nextPageUrl }])
        }, [
          i("a", o({
            class: "page-link",
            href: "#",
            "aria-label": "Next",
            tabindex: !e.computed.nextPageUrl && -1
          }, c(e.nextButtonEvents, !0)), [
            _(t.$slots, "next-nav", {}, () => [
              q
            ])
          ], 16, H)
        ], 2)) : p("", !0)
      ], 16)) : p("", !0)
    ]),
    _: 3
  }, 8, ["data", "limit", "keep-length", "onPaginationChangePage"]);
}
const ne = /* @__PURE__ */ w(M, [["render", G]]), I = {
  compatConfig: {
    MODE: 3
  },
  inheritAttrs: !1,
  emits: ["pagination-change-page"],
  components: {
    RenderlessPagination: B
  },
  props: {
    data: {
      type: Object,
      default: () => {
      }
    },
    limit: {
      type: Number,
      default: 0
    },
    keepLength: {
      type: Boolean,
      default: !1
    },
    itemClasses: {
      type: Array,
      default: () => [
        "bg-white",
        "text-gray-500",
        "border-gray-300",
        "hover:bg-gray-50"
      ]
    },
    activeClasses: {
      type: Array,
      default: () => [
        "bg-blue-50",
        "border-blue-500",
        "text-blue-600"
      ]
    }
  },
  methods: {
    onPaginationChangePage(t) {
      this.$emit("pagination-change-page", t);
    }
  }
}, J = ["disabled"], K = /* @__PURE__ */ i("span", { class: "sr-only" }, "Previous", -1), Q = /* @__PURE__ */ i("svg", {
  class: "h-5 w-5",
  "aria-hidden": "true",
  xmlns: "http://www.w3.org/2000/svg",
  fill: "none",
  viewBox: "0 0 24 24",
  "stroke-width": "1.5",
  stroke: "currentColor"
}, [
  /* @__PURE__ */ i("path", {
    "stroke-linecap": "round",
    "stroke-linejoin": "round",
    d: "M15.75 19.5L8.25 12l7.5-7.5"
  })
], -1), W = ["aria-current", "disabled"], X = ["disabled"], Y = /* @__PURE__ */ i("span", { class: "sr-only" }, "Next", -1), Z = /* @__PURE__ */ i("svg", {
  class: "w-5 h-5",
  "aria-hidden": "true",
  xmlns: "http://www.w3.org/2000/svg",
  fill: "none",
  viewBox: "0 0 24 24",
  "stroke-width": "1.5",
  stroke: "currentColor"
}, [
  /* @__PURE__ */ i("path", {
    "stroke-linecap": "round",
    "stroke-linejoin": "round",
    d: "M8.25 4.5l7.5 7.5-7.5 7.5"
  })
], -1);
function ee(t, g, a, u, f, m) {
  const h = b("RenderlessPagination");
  return r(), y(h, {
    data: a.data,
    limit: a.limit,
    "keep-length": a.keepLength,
    onPaginationChangePage: m.onPaginationChangePage
  }, {
    default: k((e) => [
      e.computed.total > e.computed.perPage ? (r(), s("nav", o({ key: 0 }, t.$attrs, {
        class: "isolate inline-flex -space-x-px rounded-md shadow-sm",
        "aria-label": "Pagination"
      }), [
        i("button", o({
          class: ["relative inline-flex items-center rounded-l-md border px-2 py-2 text-sm font-medium focus:z-20 disabled:opacity-50", a.itemClasses],
          disabled: !e.computed.prevPageUrl
        }, c(e.prevButtonEvents, !0)), [
          _(t.$slots, "prev-nav", {}, () => [
            K,
            Q
          ])
        ], 16, J),
        (r(!0), s(R, null, C(e.computed.pageRange, (n, d) => (r(), s("button", o({
          class: ["relative inline-flex items-center border px-4 py-2 text-sm font-medium focus:z-20", [
            n == e.computed.currentPage ? a.activeClasses : a.itemClasses,
            n == e.computed.currentPage ? "z-30" : ""
          ]],
          "aria-current": e.computed.currentPage ? "page" : null,
          key: d
        }, c(e.pageButtonEvents(n), !0), {
          disabled: n === e.computed.currentPage
        }), U(n), 17, W))), 128)),
        i("button", o({
          class: ["relative inline-flex items-center rounded-r-md border px-2 py-2 text-sm font-medium focus:z-20 disabled:opacity-50", a.itemClasses],
          disabled: !e.computed.nextPageUrl
        }, c(e.nextButtonEvents, !0)), [
          _(t.$slots, "next-nav", {}, () => [
            Y,
            Z
          ])
        ], 16, X)
      ], 16)) : p("", !0)
    ]),
    _: 3
  }, 8, ["data", "limit", "keep-length", "onPaginationChangePage"]);
}
const ie = /* @__PURE__ */ w(I, [["render", ee]]);
export {
  ae as Bootstrap4Pagination,
  ne as Bootstrap5Pagination,
  B as RenderlessPagination,
  ie as TailwindPagination
};
